#ifndef UTILITIES_H
#define UTILITIES_H

/****************************************************************************
 Includes
 */

#include "max.h"
#include "rwcommon.h"

/****************************************************************************
 Function prototypes
 */

int
DegenerateFace(Mesh *mesh, int face, float vertexWeldThreshold, BOOL weldVertices);

int 
NumNonDegenerateFaces(Mesh *mesh, Mtl *mat, float vertexWeldThreshold, BOOL export2SidedMaterials, BOOL weldVertices);

Mtl *
GetSubMaterial(Mtl *mat, MtlID mtId);

Texmap *
GetStdMatTexmap(Mtl *mtl, int texMapIndex);

void
getMtlTiling( Mtl *mat, int MatID,
              bool *UTiling, bool *VTiling, bool *UMirror, bool *VMirror );

BOOL
isMtlCropped(Mtl *mat, int MatID);

void
ApplyCroppingToUVs(Mtl *mat, int MatID, Point3 *UVs);

void
GetMaxUVTransform(Mtl *mat, int MatID, Matrix3 *UVTransform);

BOOL
CalcTextureOffsets(Mesh *mesh, float *uOffset, float *vOffset, Mtl *mat);

BOOL
DoubleSidedMaterial(Mtl *mat, MtlID matID);

RwReal
GetMtlTexmapAmt(Mtl *mat, int mapType, int time);

float
getMeshSelfIllumination(Mesh *mesh, Mtl *mat);

RpMaterial *
checkMaterialColors(RpMaterial *material, void *pData);

RpMaterial *
checkMaterialEffects(RpMaterial *material, void *pData);

extern INode *
findNodeByName(INode *root, char *name);

//iterate through this node's modifier stack.
//return a pointer to a modifier with given class ID if it exists,
//NULL if it doesn't
extern Modifier *
FindModifier( INode *node, const Class_ID &type );

//find the highest node (just below scene root) in same heirarchy as given node
extern INode *
FindTopOfHierarchy( INode *node );

typedef bool (FindFirstNodeInHierarchyCompareFn)(INode *);

//return the first node in a depth first search of the heirarchy that satifies
//the given compare function or 0 if nothing is found.
extern INode *
FindFirstNodeInHierarchy( INode *node, FindFirstNodeInHierarchyCompareFn f );

//find if ancestor is an ancestor of node
extern BOOL
NodeHasAncestor(INode *node, INode *ancestor);

//return first ancestor node (including given node) to satisify given condition f.
template <class F>
INode *FindFirstAncestorIf( INode *node, F f )
{
    do
    {
        if (f(node))
        {
            return node;
        }
    }
    while ((node = node->GetParentNode()) != 0)
        ;

    //not found
    return 0;
}

//Call the given function/function object with each node in the heirarchy as an argument
//along a depth-first search.
template <class F>
void ForEachNodeInHierarchy( INode *node, F & f )
{
    f( node );

    for (int i=0; i<node->NumChildren(); i++)
    {
        ForEachNodeInHierarchy<F>( node->GetChildNode(i), f );
    }
}

#endif /* UTILITIES_H*/
